%
%-------------------------------------------------------------
%
%	ROBOTRAN - Version 6.6 (build : february 22, 2008)
%
%	Copyright 
%	Universite catholique de Louvain 
%	Departement de Mecanique 
%	Unite de Production Mecanique et Machines 
%	2, Place du Levant 
%	1348 Louvain-la-Neuve 
%	http://www.robotran.be// 
%
%	==> Generation Date : Tue Jan 28 11:13:43 2020
%
%	==> Project name : pendulum_spring_matlab
%	==> using XML input file 
%
%	==> Number of joints : 4
%
%	==> Function : F 6 : Sensors Kinematical Informations (sens) 
%	==> Flops complexity : 59
%
%	==> Generation Time :  0.000 seconds
%	==> Post-Processing :  0.000 seconds
%
%-------------------------------------------------------------
%
function [sens] = sensor(s,tsim,usrfun,isens)

 sens.P = zeros(3,1);
 sens.R = zeros(3,3);
 sens.V = zeros(3,1);
 sens.OM = zeros(3,1);
 sens.A = zeros(3,1);
 sens.OMP = zeros(3,1);
 sens.J = zeros(6,4);

q = s.q; 
qd = s.qd; 
qdd = s.qdd; 
frc = s.frc; 
trq = s.trq; 

% === begin imp_aux === 

% === end imp_aux === 

% ===== BEGIN task 0 ===== 
 
% Sensor Kinematics 



% = = Block_0_0_0_0_0_1 = = 
 
% Trigonometric Variables  

  C1 = cos(q(1));
  S1 = sin(q(1));

% = = Block_0_0_0_0_0_2 = = 
 
% Trigonometric Variables  

  C3 = cos(q(3));
  S3 = sin(q(3));
  C4 = cos(q(4));
  S4 = sin(q(4));

% = = Block_0_0_0_1_0_2 = = 
 
% Trigonometric Variables  

  S3p4 = C3*S4+S3*C4;
  C3p4 = C3*C4-S3*S4;

% ====== END Task 0 ====== 

% ===== BEGIN task 1 ===== 
 
switch isens

 
% 
case 1, 


% = = Block_1_0_0_1_0_2 = = 
 
% Sensor Kinematics 


    RLcp0_14 = s.dpt(3,6)*S3;
    RLcp0_34 = s.dpt(3,6)*C3;
    OMcp0_24 = qd(3)+qd(4);
    ORcp0_14 = RLcp0_34*qd(3);
    ORcp0_34 = -RLcp0_14*qd(3);
    OPcp0_24 = qdd(3)+qdd(4);
    RLcp0_19 = s.dpt(3,8)*S3p4;
    RLcp0_39 = s.dpt(3,8)*C3p4;
    POcp0_19 = RLcp0_14+RLcp0_19+s.dpt(1,2);
    POcp0_39 = RLcp0_34+RLcp0_39;
    JTcp0_19_1 = RLcp0_34+RLcp0_39;
    JTcp0_39_1 = -(RLcp0_14+RLcp0_19);
    ORcp0_19 = OMcp0_24*RLcp0_39;
    ORcp0_39 = -OMcp0_24*RLcp0_19;
    VIcp0_19 = ORcp0_14+ORcp0_19;
    VIcp0_39 = ORcp0_34+ORcp0_39;
    ACcp0_19 = OMcp0_24*ORcp0_39+OPcp0_24*RLcp0_39+ORcp0_34*qd(3)+RLcp0_34*qdd(3);
    ACcp0_39 = -(OMcp0_24*ORcp0_19+OPcp0_24*RLcp0_19+ORcp0_14*qd(3)+RLcp0_14*qdd(3));

% = = Block_1_0_0_1_1_0 = = 
 
% Symbolic Outputs  

    sens.P(1) = POcp0_19;
    sens.P(3) = POcp0_39;
    sens.R(1,1) = C3p4;
    sens.R(1,3) = -S3p4;
    sens.R(2,2) = (1.0);
    sens.R(3,1) = S3p4;
    sens.R(3,3) = C3p4;
    sens.V(1) = VIcp0_19;
    sens.V(3) = VIcp0_39;
    sens.OM(2) = OMcp0_24;
    sens.J(1,3) = JTcp0_19_1;
    sens.J(1,4) = RLcp0_39;
    sens.J(3,3) = JTcp0_39_1;
    sens.J(3,4) = -RLcp0_19;
    sens.J(5,3) = (1.0);
    sens.J(5,4) = (1.0);
    sens.A(1) = ACcp0_19;
    sens.A(3) = ACcp0_39;
    sens.OMP(2) = OPcp0_24;
 
% 
case 2, 


% = = Block_1_0_0_2_0_1 = = 
 
% Sensor Kinematics 


    RLcp1_110 = s.dpt(3,5)*S1;
    RLcp1_310 = s.dpt(3,5)*C1;
    ORcp1_110 = RLcp1_310*qd(1);
    ORcp1_310 = -RLcp1_110*qd(1);
    ACcp1_110 = ORcp1_310*qd(1)+RLcp1_310*qdd(1);
    ACcp1_310 = -(ORcp1_110*qd(1)+RLcp1_110*qdd(1));

% = = Block_1_0_0_2_1_0 = = 
 
% Symbolic Outputs  

    sens.P(1) = RLcp1_110;
    sens.P(3) = RLcp1_310;
    sens.R(1,1) = C1;
    sens.R(1,3) = -S1;
    sens.R(2,2) = (1.0);
    sens.R(3,1) = S1;
    sens.R(3,3) = C1;
    sens.V(1) = ORcp1_110;
    sens.V(3) = ORcp1_310;
    sens.OM(2) = qd(1);
    sens.A(1) = ACcp1_110;
    sens.A(3) = ACcp1_310;
    sens.OMP(2) = qdd(1);

end


% ====== END Task 1 ====== 

  

